/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MagicHelpers {
    private static final BigDecimal TWENTY = new BigDecimal(20);

    public static String withSuffix(int count) {
        if (count < 1000) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f%c", (double)count / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static String ticksInSeconds(int ticks) {
        BigDecimal value = new BigDecimal(ticks);
        value = value.divide(TWENTY, 1, RoundingMode.HALF_UP);
        return value.toString();
    }
}

